import React, {FC} from "react";
import {Link} from "react-router-dom";
import Block from "../Block";
import Button from "../Button";
import {IAction, IPlanner, ITaskOptions} from "../../api";
import {TaskOptionsBlock} from "../TaskBlock";

export interface IRunPlannerBlockProps {
	action: IAction;
    planner: IPlanner;
    onSubmit?(task: ITaskOptions): void;
};

const RunPlannerBlock: FC<IRunPlannerBlockProps> = props => {
	const {action, planner, onSubmit} = props;
	return <form onSubmit={(event) => {
        event.preventDefault();
        onSubmit && onSubmit(planner.options);
    }}>
        <Block
            className="ui-block-planner"
            header={<h2 className="title">Run planner &laquo;<Link to={`/planners/${planner.id}`}>{planner.title}</Link>&raquo;</h2>}
            footer={<>
                <Button type="submit">Create task</Button>
                <Link to={`/planners/${planner.id}`}><Button>Back</Button></Link>
            </>}
        >
            <>Go to <a href={`/planner/${planner.id}/run`}>old interface</a>.</>
            {action.options && <TaskOptionsBlock options={action.options} taskOptions={planner.options} editable={false}/>}
        </Block>
    </form>;
};

export default RunPlannerBlock;
