import React, {TextareaHTMLAttributes, FC, useEffect, useRef} from "react";
import "./index.scss";

export interface ITextareaProps extends TextareaHTMLAttributes<HTMLTextAreaElement> {
    value?: string;
    onValueChange?(value: string): void;
}

// TODO(iudovin@): Reimplement this component with normal code.
const Textarea: FC<ITextareaProps> = props => {
	const {className, value, onValueChange, ...rest} = props;
    const textRef = useRef<HTMLTextAreaElement>(null);
    const updateSize = () => {
        if (!textRef.current) {
            return;
        }
        textRef.current.style.height = "auto";
        textRef.current.style.height = `${textRef.current.scrollHeight+2}px`;
    };
    useEffect(() => {
        window.addEventListener("resize", updateSize)
        return () => {
            window.removeEventListener("resize", updateSize);
        };
    });
    useEffect(updateSize, [value]);
	return <textarea
        ref={textRef}
        className={`ui-textarea ${className}`}
        value={value || ""}
        onChange={(event) => onValueChange && onValueChange(event.target.value)}
        {...rest}
    />;
};

export default Textarea;
