import kubernetes

import argparse
import http.server as httpserver
import json
import socket
import urllib.parse


class HTTPServerV6(httpserver.HTTPServer):
    address_family = socket.AF_INET6


def get_handler(v1):
    class handler(httpserver.BaseHTTPRequestHandler):
        api_v1 = v1

        def do_GET(self):
            parsed = urllib.parse.urlparse(self.path)
            params = urllib.parse.parse_qs(parsed.query)

            namespace = params.get('namespace', ['default'])[0]
            app = params.get('app', [None])[0]

            selector = 'app.kubernetes.io/name={}'.format(app) if app else None
            pods = self.api_v1.list_namespaced_pod(
                namespace=namespace,
                label_selector=selector
            )

            report = []
            for pod in pods.items:
                report.append({
                    'ip': pod.status.pod_ip,
                    'namespace': pod.metadata.namespace,
                    'name': pod.metadata.name,
                    'phase': pod.status.phase,
                })

            message = json.dumps(report)
            self.send_response(200)
            self.send_header('Content-type', 'application/json')
            self.end_headers()
            self.wfile.write(bytes(message, "utf8"))
    return handler


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--port", dest="port", metavar="PORT", type=int, default=80)
    args = parser.parse_args()

    port = args.port

    kubernetes.config.load_config()

    v1 = kubernetes.client.CoreV1Api()
    with HTTPServerV6(('::', port), get_handler(v1)) as httpd:
        try:
            httpd.serve_forever()
        except KeyboardInterrupt:
            print('KeyboardInterrupt')
