#include <drive/services/lpm_cache_api/src/processor.hpp>

#include <userver/components/minimal_server_component_list.hpp>
#include <userver/storages/redis/component.hpp>
#include <userver/storages/secdist/component.hpp>
#include <userver/testsuite/testsuite_support.hpp>
#include <userver/utils/daemon_run.hpp>


int main(int argc, char* argv[]) {
  const auto component_list =
      components::MinimalServerComponentList()
          .Append<drive::handlers::LPMProcessor>()
          .Append<components::Secdist>()
          .Append<components::TestsuiteSupport>()
          .Append<components::Redis>();

  return utils::DaemonMain(argc, argv, component_list);
}
