#pragma once

#include <string_view>

#include <userver/server/handlers/http_handler_base.hpp>
#include <userver/storages/redis/client.hpp>
#include <userver/storages/redis/component.hpp>


namespace drive::handlers {

class LPMProcessor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "lpm-cache-api";

 public:
  LPMProcessor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  std::string GetValue(std::string_view key, const server::http::HttpRequest& request) const;
  std::string UpsertValue(std::string_view key, const server::http::HttpRequest& request) const;
  std::string DeleteValue(std::string_view key) const;

  storages::redis::ClientPtr redis_client_;
  storages::redis::CommandControl redis_cc_;
};

}  // namespace drive::handlers
