#pragma once

#include <string_view>

#include <userver/server/handlers/http_handler_base.hpp>
#include <userver/storages/redis/client.hpp>
#include <userver/storages/redis/component.hpp>


namespace drive::handlers {

class StoreOffersProcessor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "store-offers-api";

 public:
  StoreOffersProcessor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  storages::redis::ClientPtr redis_client_;
  storages::redis::CommandControl redis_cc_;
};

class RestoreOfferProcessor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "restore-offer-api";

 public:
  RestoreOfferProcessor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  storages::redis::ClientPtr redis_client_;
  storages::redis::CommandControl redis_cc_;
};

class HandleOfferProcessor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "handle-offer-api";

 public:
  HandleOfferProcessor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  storages::redis::ClientPtr redis_client_;
  storages::redis::CommandControl redis_cc_;
};

class CountOffersProcessor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "count-offers-api";

 public:
  CountOffersProcessor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  storages::redis::ClientPtr redis_client_;
  storages::redis::CommandControl redis_cc_;
};

}  // namespace drive::handlers
