#include <drive/services/telematics_cache_api/src/handlers/api/telematics_cache_api/v1/data/processor.hpp>
#include <drive/services/telematics_cache_api/src/handlers/api/telematics_cache_api/v1/data/bulk_store/processor.hpp>
#include <drive/services/telematics_cache_api/src/handlers/api/telematics_cache_api/v1/data/retrieve/processor.hpp>
#include <drive/services/telematics_cache_api/src/handlers/api/telematics_cache_api/v1/test_data/processor.hpp>

#include <userver/components/minimal_server_component_list.hpp>
#include <userver/server/handlers/ping.hpp>
#include <userver/server/handlers/server_monitor.hpp>
#include <userver/storages/redis/component.hpp>
#include <userver/storages/secdist/component.hpp>
#include <userver/testsuite/testsuite_support.hpp>
#include <userver/utils/daemon_run.hpp>

int main(int argc, char* argv[]) {
  const auto component_list =
      components::MinimalServerComponentList()
          .Append<drive::handlers::api_telematics_cache_api_v1_data::Processor>()
          .Append<drive::handlers::api_telematics_cache_api_v1_data_bulk_store::Processor>()
          .Append<drive::handlers::api_telematics_cache_api_v1_data_retrieve::Processor>()
          .Append<drive::handlers::api_telematics_cache_api_v1_test_data::Processor>()
          .Append<components::Secdist>()
          .Append<components::TestsuiteSupport>()
          .Append<components::Redis>()
          .Append<server::handlers::Ping>()
          .Append<server::handlers::ServerMonitor>();

  return utils::DaemonMain(argc, argv, component_list);
}
