#pragma once

#include <string>
#include <string_view>

#include <userver/dynamic_config/storage/component.hpp>
#include <userver/server/handlers/http_handler_base.hpp>
#include <userver/storages/redis/client.hpp>
#include <userver/storages/redis/component.hpp>

namespace drive::handlers::api_telematics_cache_api_v1_data {

class Processor final : public server::handlers::HttpHandlerBase {
 public:
  static constexpr std::string_view kName = "handler-api-telematics-cache-api-v1-data";

  Processor(const components::ComponentConfig& config, const components::ComponentContext& context);

  std::string HandleRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const override;

 private:
  std::string HandlePutRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const;
  std::string HandleGetRequestThrow(const server::http::HttpRequest& request, server::request::RequestContext&) const;

  storages::redis::ClientPtr redis_client_;
  dynamic_config::Source config_;
};

}  // namespace drive::handlers::api_telematics_cache_api_v1_data
