// Copied from https://a.yandex-team.ru/arcadia/drive/telematics/server/pusher/common.cpp

#include "telematics_data_types.hpp"

#include <fmt/format.h>

#include <optional>
#include <sstream>

namespace drive::models::tca::telematics_data_types {

SensorId Parse(const formats::json::Value& json, formats::parse::To<SensorId>) {
  return SensorId{
      json["id"].As<uint16_t>(),
      json["sub_id"].As<uint16_t>()
  };
}

std::string GetHeartbeatKey(std::string_view name) {
    std::stringstream result;
    result << "heartbeat";
    if (!name.empty()) {
        result << ':' << name;
    }
    return result.str();
}

std::string GetLocationKey(std::string_view name) {
    std::stringstream result;
    result << "location";
    if (!name.empty()) {
        result << ':' << name;
    }
    return result.str();
}

std::optional<std::string> GetImeiFromUrl(std::string_view url) {
    if (IsHandlerUrl(url)) {
        return std::nullopt;
    }
    auto colon_pos = url.find(':');
    if (colon_pos == std::string_view::npos) {
        return std::nullopt;
    }
    url.remove_prefix(colon_pos + 1);
    colon_pos = url.find(':');
    if (colon_pos == std::string_view::npos) {
        return std::nullopt;
    }
    return std::string(url.data(), colon_pos);
}

} // namespace drive::models::tca::telematics_data_types
