// Copied from https://a.yandex-team.ru/arcadia/drive/telematics/server/pusher/common.h

#pragma once

#include <string>
#include <string_view>

#include <fmt/format.h>
#include <userver/formats/json/value.hpp>

namespace drive::models::tca::telematics_data_types {

enum class DataType : char {
    kSensor,
    kHeartbeat,
    kLocation,
    kHandler,
};

struct SensorId {
    uint16_t id = 0;
    uint16_t sub_id = 0;
};

SensorId Parse(const formats::json::Value& json, formats::parse::To<SensorId>);

std::string GetHeartbeatKey(std::string_view name);
std::string GetLocationKey(std::string_view name);

inline std::string GetSensorKey(SensorId id) {
    return fmt::format("{}:{}", id.id, id.sub_id);
}

inline std::string GetHandlerUrl(std::string_view id) {
    return fmt::format("handler:{}", id);
}

inline std::string GetHeartbeatUrl(const std::string& imei, std::string_view name) {
    return fmt::format("imei:{}:{}", imei, GetHeartbeatKey(name));
}

inline std::string GetLocationUrl(const std::string& imei, std::string_view name) {
    return fmt::format("imei:{}:{}", imei, GetLocationKey(name));
}

inline std::string GetSensorUrl(const std::string& imei, SensorId id) {
    return fmt::format("imei:{}:{}", imei, GetSensorKey(id));
}

inline bool IsHandlerUrl(std::string_view url) {
    return !url.starts_with("imei");
}

std::optional<std::string> GetImeiFromUrl(std::string_view url);

} // namespace drive::models::tca::telematics_data_types
