#pragma once

#include <chrono>

#include <userver/storages/redis/component.hpp>

namespace userver_libraries::redis_utils {

inline constexpr char symbol_not_used_in_base64 = '@';

// Documentation of storages::redis::CommandControl:https://userver-opensource.s3-website.mds.yandex.net/d2/ded/structredis_1_1CommandControl.html
constexpr storages::redis::CommandControl BuildRedisCc(const bool force_request_to_master,
                                                       const size_t timeout_single_ms = 1000,
                                                       const size_t timeout_all_ms = 1000) {
  storages::redis::CommandControl redis_cc;
  redis_cc.force_request_to_master = force_request_to_master;
  redis_cc.timeout_single = std::chrono::milliseconds(timeout_single_ms);
  redis_cc.timeout_all = std::chrono::milliseconds(timeout_all_ms);
  return redis_cc;
}

} // namespace userver_libraries::redis_utils
