#pragma once

#include "interface.h"

#include <drive/telematics/server/metadata/common.h>

namespace NRTLine {
    class TNehIndexingClient;
}

namespace NDrive {
    class TSensorApi
        : public ISensorApi
        , public TCommonMetadataClient
    {
    public:
        static TOptions DefaultOptions() {
            TOptions result;
            result.ReqClass = "SENSORS";
            return result;
        }

    public:
        TSensorApi(const TString& name, const NRTLine::TNehSearchClient& client, const TOptions& options = DefaultOptions());
        TSensorApi(const TString& name, const NRTLine::TNehSearchClient& search, const NRTLine::TNehIndexingClient& indexing, const TOptions& options = DefaultOptions());
        TSensorApi(const TString& name, const NRTLine::TNehSearchClient& search, TPusherPtr pusher, const TOptions& options = DefaultOptions());

        const TOptions& GetOptions() const {
            return Options;
        }
        const TString& GetServiceName() const {
            return Client.GetServiceName();
        }
        const TString& GetHost() const {
            return Client.GetHost();
        }
        ui16 GetPort() const {
            return Client.GetPort();
        }

        virtual TPusherPtr GetPusher() const override;

    private:
        void FillHeartbeats(const NRTLine::TSearchReply& reply, THeartbeats& result) const;
        void FillLocations(const NRTLine::TSearchReply& reply, TLocations& result, TMaybe<TString> expected = {}) const;
        void FillSensors(const NRTLine::TSearchReply& reply, TSensors& result, TMaybe<TSensorId> expected = {}) const;

        template <typename TFuture>
        void ProcessFuture(const TFuture& f) const;
        template <typename TFuture>
        void ProcessQuorum(const TVector<TFuture>& futures, const TFetchOptions& fetchOptions) const;

        virtual NThreading::TFuture<TLocations> DoGetLocations(TLocationsQueryOptions queryOptions) const override;
        virtual NThreading::TFuture<TLocations> DoGetLocations(TIMEIs imeis, TLocationsQueryOptions queryOptions) const override;

        virtual NThreading::TFuture<THeartbeats> DoGetHeartbeats(TIMEIs imeis, THeartbeatsQueryOptions queryOptions) const override;
        virtual NThreading::TFuture<THeartbeats> DoGetHeartbeats(THeartbeatsQueryOptions queryOptions) const override;

        virtual NThreading::TFuture<TSensors> DoGetSensors(TIMEIs imeis, TSensorIds ids, const TSensorsQueryOptions& queryOptions) const override;
        virtual NThreading::TFuture<TMultiSensor> DoGetSensors(const TString& imei, const TSensorsQueryOptions& queryOptions) const override;
        virtual NThreading::TFuture<TSensors> DoGetSensor(TSensorId id, const TSensorsQueryOptions& queryOptions) const override;

    private:
        TPusherPtr Pusher;
        R_FIELD(TString, Name);
    };
}
