#pragma once

#include "interface.h"

#include <drive/telematics/server/data/clickhouse/client.h>

#include <rtline/api/search_client/neh_client.h>


namespace NDrive {

    class TSensorHistoryApi : public ISensorHistoryApi {
    public:
        TSensorHistoryApi(const NRTLine::TNehSearchClient& search, const TDuration timeout)
            : Client(search)
            , Timeout(timeout)
        {}

        NThreading::TFuture<TCarsSensorsHistory> GetSensorHistory(TSensorId sensorId) const;
        NThreading::TFuture<TSensorHistory> GetSensorsHistory(const TString& imei) const;

    private:
        std::tuple<TString, NDrive::TSensorId, TSensorHistoryApi::THistory> ParseHistoryItem(const NMetaProtocol::TDocument& document) const;

    private:
        const NRTLine::TNehSearchClient& Client;
        TDuration Timeout;
    };

    class TSensorHistoryClient: public ISensorHistoryClient {
    public:
        TSensorHistoryClient(const NClickHouse::TAsyncClientOptions& options)
            : Client(options)
        {
        }

        using ISensorHistoryClient::Get;

        NThreading::TFuture<TResult> Get(
            TConstArrayRef<TString> objectIds,
            TConstArrayRef<TString> imeis,
            TInstant since,
            TInstant until = TInstant::Max(),
            TConstArrayRef<TSensorId> sensorIds = {}
        ) const override;

        const TClickHouseClient& GetClickHouseClient() const {
            return Client;
        }

    private:
        TClickHouseClient Client;
    };
}
