#pragma once

#include "interface.h"

#include <drive/telematics/server/pusher/local.h>

class TLocalSensorApi: public NDrive::ISensorApi {
public:
    TLocalSensorApi(TLocalSensorStorage::TPtr localSensorStorage);
    TLocalSensorApi();

    virtual NDrive::TPusherPtr GetPusher() const override {
        return Pusher;
    }

private:
    virtual NThreading::TFuture<TLocations> DoGetLocations(TIMEIs imeis, TLocationsQueryOptions queryOptions) const override;
    virtual NThreading::TFuture<TLocations> DoGetLocations(TLocationsQueryOptions queryOptions) const override;

    virtual NThreading::TFuture<THeartbeats> DoGetHeartbeats(TIMEIs imeis, THeartbeatsQueryOptions queryOptions) const override;
    virtual NThreading::TFuture<THeartbeats> DoGetHeartbeats(THeartbeatsQueryOptions queryOptions) const override;

    virtual NThreading::TFuture<TSensors> DoGetSensors(TIMEIs imeis, TSensorIds ids, const TSensorsQueryOptions& queryOptions) const override;
    virtual NThreading::TFuture<TMultiSensor> DoGetSensors(const TString& imei, const TSensorsQueryOptions& queryOptions) const override;
    virtual NThreading::TFuture<TSensors> DoGetSensor(NDrive::TSensorId id, const TSensorsQueryOptions& queryOptions) const override;

private:
    TLocalSensorStorage::TConstPtr LocalSensorStorage;
    NDrive::TPusherPtr Pusher;
};
