#include "config.h"

#include <util/string/split.h>
#include <util/string/vector.h>

void TTelematicsClientConfig::Init(const TYandexConfig::Section& section) {
    DestinationClientId = section.GetDirectives().Value("DestinationClientId", DestinationClientId);
    SelfClientId = section.GetDirectives().Value("SelfClientId", SelfClientId);
    Shards = StringSplitter(section.GetDirectives().Value("Shards", TString())).SplitBySet(" ,").SkipEmpty();
    FetchHost = section.GetDirectives().Value("FetchHost", FetchHost);
    FetchPort = section.GetDirectives().Value("FetchPort", FetchPort);
    FetchService = section.GetDirectives().Value("FetchService", FetchService);
    PushHost = section.GetDirectives().Value("PushHost", PushHost);
    PushPort = section.GetDirectives().Value("PushPort", PushPort);
    PushToken = section.GetDirectives().Value("PushToken", PushToken);
    SpMetaSearch = section.GetDirectives().Value("SpMetaSearch", SpMetaSearch);
    SaasTvmId = section.GetDirectives().Value("SaasTvmId", SaasTvmId);

    auto sections = section.GetAllChildren();

    for (auto&& [name, section] : sections) {
        if (name == "ServiceDiscovery") {
            const auto& directives = section->GetDirectives();
            const auto& type = directives.Value<TString>("Type");
            ServiceDiscoveryConfig = NDrive::IServiceDiscoveryConfig::TFactory::MakeHolder(type);
            Y_ENSURE(ServiceDiscoveryConfig, "cannot construct ServiceDiscoveryConfig type " << type);
            ServiceDiscoveryConfig->Init(*section);
            continue;
        }
    }
}

void TTelematicsClientConfig::ToString(IOutputStream& os) const {
    os << "DestinationClientId : " << DestinationClientId << Endl;
    os << "SelfClientId : " << SelfClientId << Endl;
    os << "Shards : " << JoinStrings(Shards, " ") << Endl;
    os << "FetchHost : " << FetchHost << Endl;
    if (FetchPort) {
        os << "FetchPort : " << FetchPort << Endl;
    }
    os << "FetchService : " << FetchService << Endl;
    os << "PushHost : " << PushHost << Endl;
    if (PushPort) {
        os << "PushPort : " << PushPort << Endl;
    }
    os << "PushToken : " << PushToken << Endl;
    if (SpMetaSearch) {
        os << "SpMetaSearch : " << SpMetaSearch << Endl;
    }
    if (SaasTvmId) {
        os << "SaasTvmId : " << SaasTvmId << Endl;
    }

    if (ServiceDiscoveryConfig) {
        os << "<ServiceDiscovery>" << Endl;
        ServiceDiscoveryConfig->ToString(os);
        os << "</ServiceDiscovery>" << Endl;
    }
}
