#pragma once

#include "sd.h"

#include <library/cpp/yconf/conf.h>

#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

class TTelematicsClientConfig {
public:
    R_READONLY(TVector<TString>, Shards);
    R_READONLY(TString, FetchHost);
    R_READONLY(ui32, FetchPort, 0);
    R_READONLY(TString, FetchService);
    R_READONLY(TString, PushHost);
    R_READONLY(ui32, PushPort, 0);
    R_READONLY(TString, PushToken);
    R_READONLY(TString, SpMetaSearch);
    R_READONLY(ui32, SelfClientId, 0);
    R_READONLY(ui32, DestinationClientId, 0);
    R_READONLY(ui32, SaasTvmId, 0);

public:
    const NDrive::IServiceDiscoveryConfig* GetServiceDiscoveryConfig() const {
        return ServiceDiscoveryConfig.Get();
    }

    void Init(const TYandexConfig::Section& section);
    void ToString(IOutputStream& os) const;

private:
    THolder<NDrive::IServiceDiscoveryConfig> ServiceDiscoveryConfig;
};
