#include "interop.h"

#include <rtline/library/json/cast.h>

NDrive::TCommonCommandResponse NDrive::MakeCommandResponse(const NDrive::TTelematicsClient::THandler& handler) {
    NDrive::TCommonCommandResponse response;
    response.Id = handler.GetId();
    response.Imei = handler.GetImei();
    response.Status = handler.GetStatus();
    response.Message = handler.GetMessage();
    response.DebugInfo = NJson::ToJson(handler.GetEvents());
    if (auto getParameterResponse = handler.GetResponse<NDrive::TTelematicsClient::TGetParameterResponse>()) {
        response.Sensor = getParameterResponse->Sensor;
    }
    return response;
}
