#pragma once

#include "client.h"

namespace NDrive {
    struct TCommonCommandResponse {
        NJson::TJsonValue DebugInfo;
        TString Id;
        TString Imei;
        TString Message;
        NDrive::TSensor Sensor;
        NDrive::TTelematicsClient::EStatus Status = NDrive::TTelematicsClient::EStatus::Unknown;

        inline TCommonCommandResponse() = default;
        inline TCommonCommandResponse(NDrive::TTelematicsClient::EStatus status, const TString& message = {})
            : Message(message)
            , Status(status)
        {
        }
    };
    using TClientCallback = TTelematicsClient::THandlerCallback;

    TCommonCommandResponse MakeCommandResponse(const TTelematicsClient::THandler& handler);
}
