#pragma once

#include <drive/telematics/api/server/sd.h>

#include <rtline/util/auto_actualization.h>
#include <rtline/util/types/field.h>

#include <library/cpp/threading/hot_swap/hot_swap.h>

namespace NDrive::NK8s {
    struct TPod {
        TString Ip;
        TString Name;
        TString Namespace;
        TString Phase;

        DECLARE_FIELDS(
            Field(Ip, "ip"),
            Field(Name, "name"),
            Field(Namespace, "namespace"),
            Field(Phase, "phase")
        );
    };
    using TPods = TVector<TPod>;

    struct TPodSnapshot: public TAtomicRefCount<TPodSnapshot> {
        TPods Pods;
        TInstant Timestamp;

        DECLARE_FIELDS(
            Field(Pods, "pods"),
            Field(Timestamp, "timestamp")
        );
    };

    struct TServiceDiscoveryOptions {
        TString Endpoint;
    };

    class TServiceDiscoveryConfig: public IServiceDiscoveryConfig {
    public:
        THolder<IServiceDiscovery> Construct() const override;

        const TServiceDiscoveryOptions& GetOptions() const {
            return Options;
        }

        static TString Type() {
            return "k8s";
        }

        void Init(const TYandexConfig::Section& section) override;
        void ToString(IOutputStream& os) const override;

    private:
        TServiceDiscoveryOptions Options;

    private:
        static TFactory::TRegistrator<TServiceDiscoveryConfig> Registrator;
    };

    class TServiceDiscovery
        : public IServiceDiscovery
        , protected IAutoActualization
    {
    public:
        TServiceDiscovery(const TServiceDiscoveryOptions& options);
        ~TServiceDiscovery();

        TVector<TString> GetHosts() const override;

        bool Refresh() override;

    private:
        TServiceDiscoveryOptions Options;

        THotSwap<TPodSnapshot> PodSnapshot;
    };
}
