#pragma once

#include <library/cpp/object_factory/object_factory.h>
#include <library/cpp/yconf/conf.h>

namespace NDrive {
    class IServiceDiscovery {
    public:
        using TPtr = TAtomicSharedPtr<IServiceDiscovery>;

    public:
        virtual ~IServiceDiscovery() = default;

        virtual TVector<TString> GetHosts() const = 0;
    };

    class IServiceDiscoveryConfig {
    public:
        using TFactory = NObjectFactory::TObjectFactory<IServiceDiscoveryConfig, TString>;

    public:
        virtual ~IServiceDiscoveryConfig() = default;

        virtual THolder<IServiceDiscovery> Construct() const = 0;

        virtual void Init(const TYandexConfig::Section& section) = 0;
        virtual void ToString(IOutputStream& os) const = 0;
    };

    class TStaticServiceDiscovery: public IServiceDiscovery {
    public:
        TStaticServiceDiscovery(TVector<TString>&& shards)
            : Shards(std::move(shards))
        {
        }
        TStaticServiceDiscovery(const TString& shard)
        {
            Shards.push_back(shard);
        }

        TVector<TString> GetHosts() const override {
            return Shards;
        }

    private:
        TVector<TString> Shards;
    };
}
