#include "config.h"
#include "service_discovery.h"

#include <util/string/split.h>
#include <util/string/vector.h>

namespace {
    NYP::NServiceDiscovery::TEndpointSetKey ParseEndpointSetId(TString& endpointSetId) {
        auto endpointSet = StringSplitter(endpointSetId).Split('#').ToList<TString>();
        const auto& cluster = endpointSet.at(0);
        const auto& endpointId = endpointSet.at(1);
        return NYP::NServiceDiscovery::TEndpointSetKey(cluster, endpointId);
    }
}

THolder<NDrive::IServiceDiscovery> TServiceDiscoveryConfig::Construct() const {
    return MakeHolder<TServiceDiscoveryManager>(*this);
}

void TServiceDiscoveryConfig::Init(const TYandexConfig::Section& section) {
    ClientName = section.GetDirectives().Value("ClientName", ClientName);
    CacheDir = section.GetDirectives().Value("CacheDir", CacheDir);
    EndpointSetIds = TVector<NYP::NServiceDiscovery::TEndpointSetKey>{};
    auto ids = StringSplitter(section.GetDirectives().Value("EndpointSetIds", TString())).SplitBySet(" ,").SkipEmpty().ToList<TString>();
    for (auto& id : ids) {
        EndpointSetIds.emplace_back(ParseEndpointSetId(id));
    }
    UpdateFrequency = section.GetDirectives().Value("UpdateFrequency", UpdateFrequency);
}

void TServiceDiscoveryConfig::ToString(IOutputStream& os) const {
    os << "ClientName : " << ClientName << Endl;
    os << "CacheDir : " << CacheDir << Endl;
    os << "EndpointSetIds : ";
    for (auto& id : EndpointSetIds) {
        os << id.ToString() << " ";
    }
    os << Endl;
    os << "Type : " << Type() << Endl;
    os << "UpdateFrequency : " << UpdateFrequency << Endl;
}

NDrive::IServiceDiscoveryConfig::TFactory::TRegistrator<TServiceDiscoveryConfig> TServiceDiscoveryConfig::Registrator(TServiceDiscoveryConfig::Type());
NDrive::IServiceDiscoveryConfig::TFactory::TRegistrator<TServiceDiscoveryConfig> TServiceDiscoveryConfig::RegistratorDefault("");
