#pragma once

#include <drive/telematics/api/server/sd.h>

#include <infra/yp_service_discovery/libs/sdlib/endpointset.h>

#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

struct TServiceDiscoveryOptions {
    TString ClientName;
    TString CacheDir;
    TVector<NYP::NServiceDiscovery::TEndpointSetKey> EndpointSetIds;
    TDuration UpdateFrequency = TDuration::Seconds(60);
};

class TServiceDiscoveryConfig
    : public NDrive::IServiceDiscoveryConfig
    , public TServiceDiscoveryOptions
{
public:
    THolder<NDrive::IServiceDiscovery> Construct() const override;

    static TString Type() {
        return "YP";
    }

    void Init(const TYandexConfig::Section& section) override;
    void ToString(IOutputStream& os) const override;

private:
    static TFactory::TRegistrator<TServiceDiscoveryConfig> Registrator;
    static TFactory::TRegistrator<TServiceDiscoveryConfig> RegistratorDefault;
};
