#pragma once

#include "config.h"

#include <infra/yp_service_discovery/libs/sdlib/endpointset.h>
#include <infra/yp_service_discovery/libs/sdlib/subscribe.h>

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/system/spinlock.h>

struct TServiceDiscoveryOptions;

namespace NYP::NServiceDiscovery {
    class TSDClient;
}

class TEndpointSetProvider: public NYP::NServiceDiscovery::IEndpointSetProvider {
public:
    TEndpointSetProvider(const NYP::NServiceDiscovery::TEndpointSetKey& key);

    void Subscribe(NYP::NServiceDiscovery::TSDClient* sdClient);

    void Update(const NYP::NServiceDiscovery::TEndpointSetEx& endpointSet) override;

    NYP::NServiceDiscovery::TEndpointSetEx GetEndpointSet() const;

private:
    TAdaptiveLock Lock_;
    NYP::NServiceDiscovery::TEndpointSetEx EndpointSet_;
    NYP::NServiceDiscovery::IEndpointSetSubscriberRef SubscribeRef_;
    NYP::NServiceDiscovery::TEndpointSetKey Key_;
};

class TServiceDiscoveryManager: public NDrive::IServiceDiscovery {
public:
    explicit TServiceDiscoveryManager(const TServiceDiscoveryOptions& config);

    virtual ~TServiceDiscoveryManager();

    TVector<TString> GetHosts() const override;

private:
    THolder<NYP::NServiceDiscovery::TSDClient> Client_;
    THashMap<NYP::NServiceDiscovery::TEndpointSetKey, THolder<TEndpointSetProvider>, NYP::NServiceDiscovery::TEndpointSetKey::THash, NYP::NServiceDiscovery::TEndpointSetKey::TEqual> Providers_;
};
