#include "client.h"

#include <util/generic/adaptor.h>

NThreading::TFuture<NDrive::TTracks> NDrive::TClickHouseTrackClient::GetTracks(const TTrackQuery& query, TDuration timeout) const {
    Y_ENSURE(!query.RideId);
    Y_ENSURE(!query.SessionId);
    Y_ENSURE(!query.Status);
    Y_ENSURE(!query.UserId);
    auto now = Now();
    auto locationQuery = TClickHouseClient::TLocationHistoryQuery();
    if (query.DeviceId) {
        locationQuery.MutableObjectIds().push_back(query.DeviceId);
    }
    if (query.IMEI) {
        locationQuery.MutableImeis().push_back(query.IMEI);
    }
    if (query.Since != TInstant::Zero()) {
        locationQuery.MutableTimestamp().From = query.Since;
    }
    if (query.Until != TInstant::Max()) {
        locationQuery.MutableTimestamp().To = query.Until;
    }
    auto locations = Client.Get(locationQuery, now + timeout);
    auto tracks = locations.Apply([query](const NThreading::TFuture<NDrive::TClickHouseClient::TLocationHistoryResult>& l) {
        NDrive::TTracks tracks;
        auto locations = l.GetValue().FindPtr(query.DeviceId);
        if (!locations) {
            return tracks;
        }
        NDrive::TTrack track;
        track.DeviceId = query.DeviceId;
        for (auto&& location : Reversed(*locations)) {
            track.Coordinates.emplace_back(location.GetCoord(), location.Timestamp, location.Speed / 3.6);
        }
        tracks.push_back(std::move(track));
        return tracks;
    });
    return tracks;
}
