#pragma once

#include <drive/telematics/client/library/client.h>
#include <drive/telematics/client/library/context.h>
#include <rtline/api/graph/router/router.h>
#include <rtline/library/scheduler/registrator.h>

#include <util/thread/pool.h>
#include <util/random/random.h>

namespace NDrive {
    class TCarEmulator {
    public:
        TCarEmulator(const TString& imei, const TString& host, const ui16 port,
            TAtomicSharedPtr<NDrive::TTelematicsClientContext> context,
            TAtomicSharedPtr<NGraph::TRouter> router = nullptr,
            TAtomicSharedPtr<NAsio::TExecutorsPool> executorsPool = nullptr,
            bool wait = true
        );
        TCarEmulator(const TString& imei, const TString& host, const ui16 port,
            TAtomicSharedPtr<NGraph::TRouter> router = nullptr,
            TAtomicSharedPtr<NAsio::TExecutorsPool> executorsPool = nullptr,
            TMaybe<TGeoCoord> position = {}
        );
        ~TCarEmulator();

        TString Name() const {
            return "car_emulator:" + IMEI + ":" + ToString(Created.MicroSeconds());
        }

        TAtomicSharedPtr<NDrive::TTelematicsTestClient> GetClient() {
            return Client;
        }
        NDrive::TTelematicsClientContext& GetContext() {
            return *Context;
        }
        const TString& GetIMEI() const {
            return IMEI;
        }
        const TString& GetHost() const {
            return Host;
        }
        ui16 GetPort() const {
            return Port;
        }

    private:
        void AddCommonHandlers(NDrive::TTelematicsTestClient& client);

    private:
        TAtomicSharedPtr<NDrive::TTelematicsTestClient> Client;
        TAtomicSharedPtr<NDrive::TTelematicsClientContext> Context;
        TAtomicSharedPtr<NGraph::TRouter> Router;
        const TInstant Created;
        const TString IMEI;
        const TString Host;
        const ui16 Port;

        NGlobalScheduler::TOptionalRegistrator GlobalSchedulerRegistrator;
    };

    NVega::TBlackboxRecords::TRecord& AddParameter(NVega::TBlackboxRecords::TRecord& record, TSensorId sensor, TSensorValue value);
    NVega::TBlackboxRecords::TRecord CreateBlackboxRecord(const TTelematicsClientContext& context);
    TGeoCoord CreateLocation(const TSet<TString>& tags);

    float GetRandomFromRange(float a, float b);
}
