#pragma once

#include <drive/telematics/client/library/handlers.h>

namespace NGraph {
    class TRouter;
}

namespace NDrive {
    class THandlerWithContext: public THandlerWithoutParams {
    protected:
        THandlerWithContext(TTelematicsTestClient& client, TTelematicsClientContext& context, NVega::ECommandCode commandCode)
            : THandlerWithoutParams(client, commandCode)
            , Context(context)
        {
        }

    protected:
        TTelematicsClientContext& Context;
    };

    class TOnOpenDrDoor: public THandlerWithContext {
    public:
        TOnOpenDrDoor(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::OPEN_DR_DOOR)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnOpenDoors: public THandlerWithContext {
    public:
        TOnOpenDoors(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::OPEN_DOORS)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnCloseDoors: public THandlerWithContext {
    public:
        TOnCloseDoors(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::CLOSE_DOORS)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnStartEngine: public THandlerWithContext {
    public:
        TOnStartEngine(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::START_ENGINE)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnStopEngine: public THandlerWithContext {
    public:
        TOnStopEngine(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::STOP_ENGINE)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnBlink : public THandlerWithContext {
    public:
        TOnBlink(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::BLINKER_FLASH)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnStartWarming: public THandlerWithContext {
    public:
        TOnStartWarming(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::YADRIVE_WARMING)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnStopWarming: public THandlerWithContext {
    public:
        TOnStopWarming(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::YADRIVE_STOP_WARMING)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TCanRequestHandler: public TCommonHandler {
    public:
        TCanRequestHandler(TTelematicsClientContext& context)
            : Context(context)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        TTelematicsClientContext& Context;
    };

    class TGetParamHandler : public TCommonHandler {
    public:
        TGetParamHandler(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : Client(client)
            , Context(context)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        TTelematicsTestClient& Client;
        TTelematicsClientContext& Context;
    };

    class TSetParamHandler : public TCommonHandler {
    public:
        TSetParamHandler(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : Client(client)
            , Context(context)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        template<typename T>
        void HandleValue(const NDrive::TSensorRef& value, NVega::TCommandResponse& response, std::function<bool(const NDrive::TSensorRef& value)> setter);

    private:
        TTelematicsTestClient& Client;
        TTelematicsClientContext& Context;
    };

    class TObdForwardConfigHandler: public TCommonHandler {
    public:
        TObdForwardConfigHandler(TTelematicsClientContext& context)
            : Context(context)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        TTelematicsClientContext& Context;
    };

    class TMoveToCoordHandler: public TCommonHandler {
    public:
        TMoveToCoordHandler(TTelematicsTestClient& client, TTelematicsClientContext& context, TAtomicSharedPtr<NGraph::TRouter> router);
        ~TMoveToCoordHandler();

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        void MoveTo(double latitide, double longitude, double speed);

    private:
        TTelematicsTestClient& Client;
        TTelematicsClientContext& Context;
        TAtomicSharedPtr<NGraph::TRouter> Router;
    };

    class TOnStartOfLease: public THandlerWithContext {
    public:
        TOnStartOfLease(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::YADRIVE_START_OF_LEASE)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnEndOfLease: public THandlerWithContext {
    public:
        TOnEndOfLease(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::YADRIVE_END_OF_LEASE)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnForcedEndOfLease : public THandlerWithContext {
    public:
        TOnForcedEndOfLease(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::YADRIVE_FORCED_END_OF_LEASE)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TOnGsmModemCommand : public THandlerWithContext {
    public:
        TOnGsmModemCommand(TTelematicsTestClient& client, TTelematicsClientContext& context)
            : THandlerWithContext(client, context, NVega::ECommandCode::GSM_MODEM_COMMAND)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TDisconnectCommand : public THandlerWithoutParams {
    public:
        TDisconnectCommand(TTelematicsTestClient& client)
            : THandlerWithoutParams(client, NVega::ECommandCode::DISCONNECT)
        {
        }

        bool ProcessCommand(NVega::IConnection& connection) override;
    };

    class TGetFileHandler: public TCommonHandler {
    public:
        TGetFileHandler(TTelematicsTestClient& client)
            : Client(client)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

        size_t GetCount() const {
            return Count;
        }

    private:
        TTelematicsTestClient& Client;
        size_t Count = 0;
    };

    class TSetFileHandler: public TCommonHandler {
    public:
        TSetFileHandler(TTelematicsTestClient& client)
            : Client(client)
        {
        }

        TTelematicsTestClient::EHandlerStatus OnMessage(NVega::IConnection& connection, const NProtocol::IMessage& message) override;

    private:
        TTelematicsTestClient& Client;
    };
}
