#pragma once

#include <drive/telematics/protocol/sensor.h>

#include "client.h"

namespace NDrive {
    class TTelematicsProxy {
    public:
        TTelematicsProxy(const TString& host, ui16 port);

        TVector<TString> List(TDuration timeout = TDuration::Seconds(30));
        TBuffer GetFile(const TString& name, ssize_t offset = 0, TDuration timeout = TDuration::Seconds(300));
        void SetFile(const TString& name, TBuffer&& content, TDuration timeout = TDuration::Seconds(300));

        void Connect(const TString& imei, TConstArrayRef<TString> passwords = {}, TDuration timeout = TDuration::Seconds(30));
        void Disconnect();

        void Command(NDrive::NVega::ECommandCode code, TDuration timeout = TDuration::Seconds(30));
        TSensorValue GetParameter(ui16 id, ui16 subid = 0, TDuration timeout = TDuration::Seconds(30));
        template <class T>
        void SetParameter(ui16 id, ui16 subid, T value, TDuration timeout = TDuration::Seconds(30));

    private:
        const TString Host;
        const ui16 Port;

        TTelematicsTestClient Client;

        std::atomic<ui32> MessageId;
    };
}
