#include "beacon.h"

#include <util/stream/str.h>

// NOTE: We assume the system is little-endian

namespace {
    ui16 ChangeEndianness(ui16 value) {
        ui8 high = (value >> 8) & ((1 << 8) - 1);
        ui8 low = value & ((1 << 8) - 1);
        return (low << 8) + high;
    }
    ui32 ChangeEndianness(ui32 value) {
        ui8 mask = ((1 << 8) - 1);
        ui8 byte1 = (value >> 24) & mask;
        ui8 byte2 = (value >> 16) & mask;
        ui8 byte3 = (value >> 8) & mask;
        ui8 byte4 = value & mask;
        return (byte4 << 24) | (byte3 << 16) | (byte2 << 8) | byte1;
    }
}

ui16 NDrive::NVega::TBeaconInfo::GetMajor() const {
    return ChangeEndianness(Major);
} 

ui16 NDrive::NVega::TBeaconInfo::GetMinor() const {
    return ChangeEndianness(Minor);
}

TGUID NDrive::NVega::TBeaconInfo::GetUUID() const {
    return {ChangeEndianness(UUID[0]), ChangeEndianness(UUID[1]), ChangeEndianness(UUID[2]), ChangeEndianness(UUID[3])};
}

NDrive::NVega::TBeaconInfo::TUUIDType& NDrive::NVega::TBeaconInfo::MutableRawUUID() noexcept {
    return UUID;
}

ui16& NDrive::NVega::TBeaconInfo::MutableRawMajor() noexcept {
    return Major;
}

ui16& NDrive::NVega::TBeaconInfo::MutableRawMinor() noexcept {
    return Minor;
}
