#pragma once

#include <array>

#include <drive/telematics/protocol/vega_private.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/buffer.h>
#include <util/generic/guid.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NDrive {
    namespace NVega {
        class TBeaconInfo {
        public:
            using TMacAddressType = std::array<ui8, 6>;
            using TUUIDType = std::array<ui32, 4>;
            template<int N>
            using TGarbageType = std::array<ui8, N>;

        private:
            TUUIDType UUID;
            ui16 Major = 0;
            ui16 Minor = 0;
            R_FIELD(TMacAddressType, MacAddress);
            R_FIELD(i8, RSSI, 0);
            R_FIELD(ui8, Dlen, 0);
            R_FIELD(TGarbageType<9>, Garbage1);
            R_FIELD(TGarbageType<2>, Garbage2);

        public:
            DEFINE_FIELDS(MacAddress, RSSI, Dlen, Garbage1, UUID, Major, Minor, Garbage2);

        public:
            ui16 GetMajor() const;
            ui16 GetMinor() const;
            TGUID GetUUID() const;
            TUUIDType& MutableRawUUID() noexcept;
            ui16& MutableRawMajor() noexcept;
            ui16& MutableRawMinor() noexcept;
        };

        class TBeaconInfos {
        public:
            std::array<TBeaconInfo, 6> Elements;
            DEFINE_FIELDS(
                Elements[0],
                Elements[1],
                Elements[2],
                Elements[3],
                Elements[4],
                Elements[5]
            );
        };
    }
}
