#include "beacon.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(BeaconSuite) {
    Y_UNIT_TEST(BeaconInfo) {
        TString str = "\1\1\1\1\2\3"                           // MacAddress
                      "\4"                                     // RSSI
                      "\5"                                     // Dlen
                      "\1\1\1\1\1\1\1\1\6"                     // Garbage1
                      "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1A\x1B\x1C\x1D\x1E\x1F" // UUID
                      "\xA\xB"                                 // Major
                      "\xC\xD"                                 // Minor
                      "\xE\xF"                                 // Garbage2
        ;

        NDrive::NVega::TBeaconInfo beaconInfo;
        TStringInput input(str);
        beaconInfo.Load(&input);
        NDrive::NVega::TBeaconInfo::TMacAddressType expMacAddress{1, 1, 1, 1, 2, 3};
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetMacAddress(), expMacAddress);
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetRSSI(), 4);
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetDlen(), 5);

        NDrive::NVega::TBeaconInfo::TGarbageType<9> expGarbage1{1, 1, 1, 1, 1, 1, 1, 1, 6};
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetGarbage1(), expGarbage1);
        ui32 expectedUUID1 = (19 + 256 * 18 + 256 * 256 * 17 + 256 * 256 * 256 * 16);
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetUUID().dw[0], expectedUUID1);
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetMajor(), 10 * (1 << 8) + 11);
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetMinor(), 12 * (1 << 8) + 13);
        NDrive::NVega::TBeaconInfo::TGarbageType<2> expGarbage2{14, 15};
        UNIT_ASSERT_VALUES_EQUAL(beaconInfo.GetGarbage2(), expGarbage2);

        TString encoded;
        TStringOutput output(encoded);
        beaconInfo.Save(&output);
        UNIT_ASSERT_VALUES_EQUAL(encoded, str);
    }
}
