#pragma once

#include <drive/library/cpp/common/object_sharding.h>

#include <util/generic/string.h>

namespace NDrive {
    namespace NVega {
        struct TFirmwareInfo {
            enum EFeature {
                Panic = 1 << 0,
                FastData = 1 << 1,
                SwitchSim = 1 << 2,
            };
            enum EType {
                Unknown,
                MT25K   /* "MT-25K" */,
                MT32K   /* "MT-32K LTE" */,
                MT32K_2 /* "MT-32K LTE V2" */,
                MT32K_3 /* "MT-32K LTE V3" */,
                MT32K_MTX /* "MT-32K LTE 'MTX'" */,
            };

            TString Alias;
            TString FullName;
            TString Model;
            TString Tag;
            ui32 Revision = 0;
            EType Type = Unknown;
            EType SubType = Unknown;
            ui8 Percent = 0;

            const TString& GetName() const {
                return Alias ? Alias : FullName;
            }
            ui32 GetCanCount() const;

            bool operator< (const TFirmwareInfo& other) const;
            bool IsCompatibleWith(const TFirmwareInfo& other) const;
            bool IsFeatureSupported(EFeature feature) const;
            bool CanBeTanker() const;
            bool CanUpdateFuel() const;
        };

        TString NormalizeFirmwareName(const TString& name);
        TFirmwareInfo ParseFirmwareInfo(const TString& name);
    }
}
