#include "firmware.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(FirmwareSuite) {
    Y_UNIT_TEST(Info) {
        const TVector<TString> examples = {
            "VEGA MT-25K 0.10b rc29 LP 'Kaptur'",
            "VEGA MT-25K 0.10b rc29 LP 'Rio'",
            "VEGA MT-25K 0.10b rc30 LP 'Kaptur' test8",
            "VEGA MT-25K 0.10b rc30 LP 'Rio' test8",
            "VEGA MT-32K LTE 0.10b rc26 LP  'Rio' prod",
            "VEGA MT-32K LTE 0.10b rc28 LP 'A3' test 1",
            "VEGA MT-32K LTE 0.10b rc29 LP 'Kaptur'",
            "VEGA MT-32K LTE 0.10b rc29 LP 'Octavia' test 1",
            "VEGA MT-32K LTE 0.10b rc29 LP 'Rio'",
            "VEGA MT-32K LTE 0.10b rc30 LP '520i' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP '520i' test12",
            "VEGA MT-32K LTE 0.10b rc30 LP '911' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP 'A3' startstop",
            "VEGA MT-32K LTE 0.10b rc30 LP 'E200' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Genesis' test9",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Macan' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Octavia' test9",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Polo' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Polo' test6",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Q3' test11",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Rapid' test6",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Rapid' test9",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Rio' test10",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Rio' test8",
            "VEGA MT-32K LTE 0.10b rc30 LP 'Solaris' test3",
            "VEGA MT-32K LTE 0.10b rc31 'Kaptur' panic1",
            "VEGA MT-32K LTE 0.10b rc31 'Rapid' test1",
            "VEGA MT-32K LTE 0.10b rc31 'Rio' panic1",
            "VEGA MT-32K LTE 0.10b rc31 'Rio' panic3",
            "VEGA MT-32K LTE 0.10b rc31 'Solaris' test1",
            "VEGA MT-32K LTE V2 0.10b rc31 'Kaptur' panic2",
            "VEGA MT-32K LTE V2 0.10b rc31 'Polo' panic3",
            "VEGA MT-32K LTE V2 0.10b rc31 'Rio' panic3",
            "VEGA MT-32K LTE V2 0.10b rc31 'Rio' prod",
            "VEGA MT-32K LTE V2 0.10b rc32 'Kaptur' prod",
            "VEGA MT-32K LTE V2 0.10b rc32 'Polo' panic3",
        };

        for (auto&& example : examples) {
            NDrive::NVega::TFirmwareInfo info = NDrive::NVega::ParseFirmwareInfo(example);
            UNIT_ASSERT(info.Type != NDrive::NVega::TFirmwareInfo::Unknown);
            UNIT_ASSERT(info.Revision > 25);
            UNIT_ASSERT(!info.Model.empty());
        }
    }

    Y_UNIT_TEST(Features) {
        NDrive::NVega::TFirmwareInfo info = NDrive::NVega::ParseFirmwareInfo("VEGA MT-32K LTE 0.10b rc37 'Kaptur'");
        UNIT_ASSERT(info.IsFeatureSupported(NDrive::NVega::TFirmwareInfo::Panic));
    }

    Y_UNIT_TEST(MTX) {
        {
            NDrive::NVega::TFirmwareInfo info = NDrive::NVega::ParseFirmwareInfo("VEGA MT-32K LTE 0.10b rc40 'MTX' t1");
            UNIT_ASSERT_VALUES_EQUAL(info.Type, NDrive::NVega::TFirmwareInfo::MT32K_MTX);
            UNIT_ASSERT_VALUES_EQUAL(info.SubType, NDrive::NVega::TFirmwareInfo::MT32K);
        }

        {
            NDrive::NVega::TFirmwareInfo info = NDrive::NVega::ParseFirmwareInfo("VEGA MT-32K LTE V2 0.10b rc40 'MTX' t1");
            UNIT_ASSERT_VALUES_EQUAL(info.Type, NDrive::NVega::TFirmwareInfo::MT32K_MTX);
            UNIT_ASSERT_VALUES_EQUAL(info.SubType, NDrive::NVega::TFirmwareInfo::MT32K_2);
        }

        {
            NDrive::NVega::TFirmwareInfo info = NDrive::NVega::ParseFirmwareInfo("VEGA MT-32K LTE V3 0.10b rc40 'MTX' t1");
            UNIT_ASSERT_VALUES_EQUAL(info.Type, NDrive::NVega::TFirmwareInfo::MT32K_MTX);
            UNIT_ASSERT_VALUES_EQUAL(info.SubType, NDrive::NVega::TFirmwareInfo::MT32K_3);
        }

    }
}
