#include "handler.h"

#include <util/random/random.h>
#include <util/string/builder.h>
#include <util/system/hostname.h>

void NDrive::NProtocol::TCallbackHandler::OnAdd(IConnection& connection) {
    if (Handler) {
        Handler->OnAdd(connection);
    }
}

void NDrive::NProtocol::TCallbackHandler::OnDrop() {
    if (Handler) {
        Handler->OnDrop();
    }
    InvokeCallback();
}

NDrive::NProtocol::EHandlerStatus NDrive::NProtocol::TCallbackHandler::OnMessage(IConnection& connection, const IMessage& message) {
    auto status = Handler ? Handler->OnMessage(connection, message) : EHandlerStatus::Finish;
    switch (status) {
    case NDrive::NProtocol::EHandlerStatus::Finish:
        InvokeCallback();
        break;
    case NDrive::NProtocol::EHandlerStatus::Continue:
        break;
    }
    return status;
}

void NDrive::NProtocol::TCallbackHandler::InvokeCallback() {
    if (Callback) {
        Callback(Handler);
        Callback = nullptr;
    }
}

void NDrive::NProtocol::TCommonHandler::OnAdd(IConnection& /*connection*/) {
}

void NDrive::NProtocol::TCommonHandler::OnDrop() {
    Dropped = true;
    Ev.Signal();
}

TString NDrive::NProtocol::GenerateId(TStringBuf imei, TStringBuf type) {
    auto result = TStringBuilder() << imei
        << '-' << Now().MicroSeconds()
        << '-' << RandomNumber<ui16>()
        << '-' << TStringBuf(HostName()).Before('.').SubString(0, 16);
    if (type) {
        result << '-' << type;
    }
    return result;
}

void NDrive::NProtocol::HandleCommon(IConnection& connection, TAtomicSharedPtr<TCommonHandler> handler, TDuration timeout) {
    connection.AddMessageHandler(handler);
    handler->Wait(timeout);
    Y_ENSURE(!handler->WasDropped(), "connection was dropped");
}
