#!/usr/bin/env bash

FILENAME=$(basename $1)

if [ "$FILENAME" = "testing.conf" ]; then
    TYPE="YA_DRIVE_TELEMATICS_CONFIG_TESTING"
elif [ "$FILENAME" = "prestable.conf" ]; then
    TYPE="YA_DRIVE_TELEMATICS_CONFIG_PRESTABLE"
elif [ "$FILENAME" = "stable.conf" ]; then
    TYPE="YA_DRIVE_TELEMATICS_CONFIG_STABLE"
elif [ "$FILENAME" = "wialon.conf"]; then
    TYPE="YA_DRIVE_TELEMATICS_CONFIG_WIALON"
else
    echo "cannot determine resource type for $FILENAME"
    exit -1
fi

echo "uploading $1 with type $TYPE"
ya upload --backup --ttl 42 --type $TYPE $1
