#pragma once

#include "vega.h"

#include <rtline/util/types/expected.h>

namespace NDrive {
    namespace NVega {
        struct TCommand {
            ECommandCode Code;
            TArgument Argument;

            inline TCommand(ECommandCode code = ECommandCode::UNKNOWN, TArgument argument = {})
                : Code(code)
                , Argument(std::move(argument))
            {
            }

            explicit operator bool() const {
                return Code != ECommandCode::UNKNOWN;
            }

            static TCommand GetParameter(TSensorId sensor);
            static TCommand SetParameter(TSensorId sensor, TSensorValue value, bool polite = false);
        };
    }

    TVector<TStringBuf> ListActions();
    TMaybe<NVega::ECommandCode> ParseAction(TStringBuf action);
    TMaybe<NVega::TArgument> ParseArgument(TStringBuf action);
    TExpected<NVega::TCommand, yexception> ParseCommand(const NJson::TJsonValue& value);
}
