#include "actions.h"

#include <rtline/library/json/cast.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TelematicsActions) {
    Y_UNIT_TEST(Json) {
        {
            NDrive::NVega::TCommand command(NDrive::NVega::ECommandCode::OBD_FORWARD_CONFIG);
            NDrive::NVega::TCommandRequest::TCustomObdForwardConfig config;
            config.Duration = 42;
            config.Value = 243;
            config.Mask = 144;
            command.Argument.Set(config);

            auto serialized = NJson::ToJson(command);
            auto deserialized = NJson::FromJson<NDrive::NVega::TCommand>(serialized);
            auto deserializedConfig = deserialized.Argument.Get<NDrive::NVega::TCommandRequest::TCustomObdForwardConfig>();
            UNIT_ASSERT_VALUES_EQUAL(deserializedConfig.Duration, config.Duration);
            UNIT_ASSERT_VALUES_EQUAL(deserializedConfig.Value, config.Value);
            UNIT_ASSERT_VALUES_EQUAL(deserializedConfig.Mask, config.Mask);
        }

        {
            NDrive::NVega::TCommand command(NDrive::NVega::ECommandCode::BLINKER_FLASH);
            NDrive::NVega::TCommandRequest::TBlinkerFlash config;
            config.Time = 2;
            config.Sampling = 200;
            command.Argument.Set(config);

            auto serialized = NJson::ToJson(command);
            auto deserialized = NJson::FromJson<NDrive::NVega::TCommand>(serialized);
            auto deserializedConfig = deserialized.Argument.Get<NDrive::NVega::TCommandRequest::TBlinkerFlash>();
            UNIT_ASSERT_VALUES_EQUAL(deserializedConfig.Time, config.Time);
            UNIT_ASSERT_VALUES_EQUAL(deserializedConfig.Sampling, config.Sampling);
        }
    }
}
