#pragma once

#include "sensor.h"

namespace NDrive {
    namespace NVega {
        class TSensorCalibration {
        public:
            struct TElement {
                double Original;
                double Calibrated;
                double Slope;

                inline bool operator<(const TElement& other) const {
                    return Original < other.Original;
                }
                inline bool operator<(double original) const {
                    return Original < original;
                }
            };
            using TTable = TVector<TElement>;

        public:
            double GetMaxCalibrated() const;
            double Get(double original) const;
            double Get(const TSensor& original) const;

            bool Empty() const {
                return Table.empty();
            }

            const TTable& GetTable() const {
                return Table;
            }

            void SetTable(TTable&& value);

        private:
            void Finalize();

        private:
            static constexpr double Precision = 0.001;

        private:
            TTable Table;
        };
    }
}
