#include "calibration.h"

#include <rtline/library/json/cast.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(CalibrationSuite) {
    Y_UNIT_TEST(Simple) {
        TString raw = R"(
{
    "table": [
        {
            "original": 0,
            "calibrated": 42
        },
        {
            "original": 41,
            "calibrated": 1000
        },
        {
            "original": 42,
            "calibrated": 1000
        },
        {
            "original": 1042,
            "calibrated": 2000
        }
    ]
}
        )";
        NJson::TJsonValue json = NJson::ReadJsonFastTree(raw);

        auto calibrator = NJson::FromJson<NDrive::NVega::TSensorCalibration>(json);
        UNIT_ASSERT_VALUES_EQUAL(calibrator.GetTable().size(), 4);

        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(0), 42, 0.00001);
        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(41), 1000, 0.00001);
        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(42), 1000, 0.00001);
        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(1042), 2000, 0.00001);

        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(-42), -939.36585, 0.00001);
        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(41.5), 1000, 0.00001);
        UNIT_ASSERT_DOUBLES_EQUAL(calibrator.Get(442), 1400, 0.00001);
    }
}
