#pragma once

#include <util/generic/cast.h>
#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/string/cast.h>

class IInputStream;
class IOutputStream;

namespace NDrive {
    class TIncompleteDataException: public yexception {
    public:
        TIncompleteDataException(size_t expected, size_t received)
            : Expected(expected)
            , Received(received)
        {
        }

        size_t GetExpected() const {
            return Expected;
        }
        size_t GetReceived() const {
            return Received;
        }

    private:
        size_t Expected;
        size_t Received;
    };
}
