#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NDrive {
    ui32 VegaCrc32(const unsigned char* begin, const unsigned char* end);
    ui32 VegaCrc32(const char* begin, const char* end);
    ui16 VegaCrc16(const unsigned char* begin, const unsigned char* end);
    ui16 VegaCrc16(const char* begin, const char* end);

    ui16 WialonCrc16(const char* begin, const char* end);
    ui16 WialonCrc16(ui16 init, const char* begin, const char* end);

    ui8 NavTelecomCrc8(const char* begin, const char* end);
    ui8 NavTelecomFlexCrc8(const char* begin, const char* end);
}
