#include "crc.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/string/hex.h>

Y_UNIT_TEST_SUITE(TelematicsCheckSum) {
    Y_UNIT_TEST(CRC32) {
        TStringBuf s = "2.0;imei;N/A";
        auto crc = NDrive::VegaCrc32(s.begin(), s.end());
        UNIT_ASSERT_VALUES_EQUAL(crc, 0x348d9d73);
    }

    Y_UNIT_TEST(WialonIpsCrc16) {
        TStringBuf s = "2.0;869286035183933;NA;";
        auto crc = NDrive::WialonCrc16(s.begin(), s.end());
        UNIT_ASSERT_VALUES_EQUAL(crc, 0x9E33);
    }

    Y_UNIT_TEST(NavTelecomCrc8) {
        TString s = HexDecode("404E544301000000000000001A001B");
        auto crc = NDrive::NavTelecomCrc8(s.begin(), s.end());
        UNIT_ASSERT_VALUES_EQUAL(crc, 0x19);
    }

    Y_UNIT_TEST(NavTelecomFlexCrc8) {
        TString s = HexDecode("7E41011E000000B017E11D7456001F142F");
        auto crc = NDrive::NavTelecomFlexCrc8(s.begin(), s.end());
        UNIT_ASSERT_VALUES_EQUAL(crc, 0x24);
    }
}
