#pragma once

#include <library/cpp/langs/langs.h>

#include <util/generic/strbuf.h>

namespace NDrive {
    enum class ETelematicsNotification : ui32 {
        Unknown = 0,

        // errors
        DriverDoorOpen = 1,
        PassengerDoorOpen = 2,
        LeftRearDoorOpen = 3,
        RightRearDoorOpen = 4,
        HoodOpen = 5,
        TrunkOpen = 6,
        EngineOn = 7,
        WrongKeyPosition = 8,
        WrongSelectorPosition = 9,
        IgnitionOn = 10,
        LightsOn = 11,
        EngineRunFailure = 12,
        WrongLightSwitchPosition = 13,
        WindowsNotClosed = 14,
        DoorsNotLocked = 15,
        WrongHandbrakePosition = 16,
        DriverWindowOpen = 17,
        PassengerWindowOpen = 18,
        DriverWindowLeafOpen = 19,
        PassengerWindowLeafOpen = 20,
        NoFuelCap = 21,
        ExternalBoardError = 22,
        RoofIsOpen = 23,
        LeftRoofLockIsOpen = 24,
        RightRoofLockIsOpen = 25,
        LeftRearWindowOpen = 26,
        RightRearWindowOpen = 27,
        WrongTransferCaseSelectorPosition = 28,
        RoofIsOpen2 = 29,
        KeyIsNotInIgnition = 30,

        // infra
        ConnectionNotFound = 100,
        WaitTimeout = 101,

        // progress
        EngineRunning = 1000,
    };

    bool IsError(TStringBuf text);
    ETelematicsNotification ParseError(TStringBuf text);

    TString GetErrorDescription(ETelematicsNotification value);
    TString GetUserErrorDescription(ETelematicsNotification value, ELanguage language = LANG_RUS);
}
