#include "errors.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TelematicsErrors) {
    Y_UNIT_TEST(ErrorsParser) {
        UNIT_ASSERT(!NDrive::IsError("check parking and light ok"));
        UNIT_ASSERT(!NDrive::IsError("engine already stopped"));
        UNIT_ASSERT(!NDrive::IsError("end of lease done"));

        UNIT_ASSERT(NDrive::IsError("break, wrong light switch position"));
        UNIT_ASSERT(NDrive::IsError("break, windows not closed"));
        UNIT_ASSERT(NDrive::IsError("break, door not locked"));

        UNIT_ASSERT(NDrive::IsError("engine run fail"));

        UNIT_ASSERT_VALUES_EQUAL(NDrive::ParseError("break, wrong light switch position"), NDrive::ETelematicsNotification::WrongLightSwitchPosition);
        UNIT_ASSERT_VALUES_EQUAL(NDrive::ParseError("break, windows not closed"), NDrive::ETelematicsNotification::WindowsNotClosed);
        UNIT_ASSERT_VALUES_EQUAL(NDrive::ParseError("break, door not locked"), NDrive::ETelematicsNotification::DoorsNotLocked);
    }
}
