#include "log.h"

#include <util/string/split.h>

namespace {
    TInstant ParseLogDate(TStringBuf date, TStringBuf time) {
        struct tm ts;
        Zero(ts);

        TStringBuf token;
        Y_ENSURE(date.NextTok('/', token));
        ts.tm_mday = FromString<int>(token);
        Y_ENSURE(date.NextTok('/', token));
        ts.tm_mon = FromString<int>(token) - 1;
        Y_ENSURE(date.NextTok('/', token));
        ts.tm_year = FromString<int>(token) - 1900;

        Y_ENSURE(time.NextTok(':', token));
        ts.tm_hour = FromString<int>(token);
        Y_ENSURE(time.NextTok(':', token));
        ts.tm_min = FromString<int>(token);
        Y_ENSURE(time.NextTok(':', token));
        ts.tm_sec = FromString<int>(token);

        return TInstant::Seconds(TimeGM(&ts));
    }
}

NDrive::NVega::TLogRecord NDrive::NVega::ParseLogRecord(TStringBuf raw) try {
    if (!raw) {
        return {};
    }
    if (raw[0] != '[') {
        return TString(raw);
    }
    TStringBuf s = raw;

    TStringBuf date = s.Before(']').After('[');
    s = s.After(']');

    TStringBuf time = s.Before(']').After('[');
    s = s.After(']');

    TStringBuf message = s;
    TInstant timestamp = ParseLogDate(date, time);
    return { TString(message), timestamp };
} catch (const yexception& e) {
    Cdbg << "cannot parse VEGA log record " << raw << ": " << e.what() << Endl;
    return { TString(raw) };
}

NDrive::NVega::TLogRecords NDrive::NVega::ParseLogRecords(TStringBuf data) {
    NDrive::NVega::TLogRecords result;
    for (auto&& i : StringSplitter(data).Split('\n').SkipEmpty()) {
        result.push_back(ParseLogRecord(i.Token()));
    }
    return result;
}
