#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <tuple>

namespace NDrive {
    namespace NVega {
        struct TLogRecord {
            TString Message;
            TInstant Timestamp;

            TLogRecord() = default;
            TLogRecord(const TString& message, TInstant timestamp = TInstant::Zero())
                : Message(message)
                , Timestamp(timestamp)
            {
            }

            inline bool operator<(const TLogRecord& other) const {
                return std::tie(Timestamp, Message) < std::tie(other.Timestamp, other.Message);
            }
            inline bool operator==(const TLogRecord& other) const {
                return std::tie(Timestamp, Message) == std::tie(other.Timestamp, other.Message);
            }
        };
        using TLogRecords = TVector<TLogRecord>;

        TLogRecord ParseLogRecord(TStringBuf raw);
        TLogRecords ParseLogRecords(TStringBuf data);
    }
}
