#include "log.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TelematicsLogs) {
    Y_UNIT_TEST(LogParser) {
        {
            TString sample = "[11/7/2018][16:10:48]sent doors lock cmd by speed (6, 48)";
            auto record = NDrive::NVega::ParseLogRecord(sample);
            UNIT_ASSERT(record.Message);
            UNIT_ASSERT(record.Timestamp);
            UNIT_ASSERT(record.Timestamp.ToString().find("2018-07-11") != TString::npos);
            UNIT_ASSERT(record.Timestamp.ToString().find("16:10:48") != TString::npos);
        }
        {
            TString sample = "[15/7/2018][22:16:2]CAN2 wakeup";
            auto record = NDrive::NVega::ParseLogRecord(sample);
            UNIT_ASSERT(record.Message);
            UNIT_ASSERT(record.Timestamp);
            UNIT_ASSERT(record.Timestamp.ToString().find("2018-07-15") != TString::npos);
            UNIT_ASSERT(record.Timestamp.ToString().find("22:16:02") != TString::npos);
        }
        {
            TString sample = "[21/7/2018][16:48:30]syscom_man: System start, FW version VEGA MT-32K LTE 0.10b rc28 LP  'Q3' test 1 from Jun  3 2018 20:38:24";
            auto record = NDrive::NVega::ParseLogRecord(sample);
            UNIT_ASSERT(record.Message);
            UNIT_ASSERT(record.Timestamp);
            UNIT_ASSERT(record.Timestamp.ToString().find("2018-07-21") != TString::npos);
            UNIT_ASSERT(record.Timestamp.ToString().find("16:48:30") != TString::npos);
        }
    }
}
