#include "mio.h"

#include <library/cpp/logger/global/global.h>

#include <algorithm>

TFlushBufferedOutputStream::TFlushBufferedOutputStream(IOutputStream& output, size_t flushSize)
    : Output(output)
    , FlushSize(flushSize)
{
    CHECK_WITH_LOG(FlushSize);
}

void TFlushBufferedOutputStream::DoWrite(const void* buf, size_t len) {
    auto begin = reinterpret_cast<const char*>(buf);
    auto end = begin + len;
    for (auto data = begin; data < end; data += FlushSize) {
        auto size = std::min<size_t>(end - data, FlushSize);
        Output.Write(data, size);
        Output.Flush();
    }
}

void TFlushBufferedOutputStream::DoFlush() {
    Output.Flush();
}
