#include "nonce.h"

namespace {
    template <class T>
    const ui8* memread(T& value, const ui8* begin, const ui8* end) {
        Y_ASSERT(begin <= end);
        auto object = &value;
        auto size = sizeof(value);
        Y_ASSERT(begin + size <= end);
        auto read = std::memcpy(object, begin, std::min<size_t>(size, end - begin));
        Y_ASSERT(object == read);
        return std::min(begin + size, end);
    }
}

NDrive::TCompositeNonce NDrive::Decode(const NDrive::NVega::TCommandResponseSigned::TNonce& nonce) {
    ui32 timestamp = 0;
    ui32 hash = 0;
    auto p = nonce.begin();
    p = memread(timestamp, p, nonce.end());
    p = memread(hash, p, nonce.end());
    Y_ASSERT(p == nonce.end());
    return {
        TInstant::Seconds(timestamp),
        hash
    };
}
