#include "poly1305.h"

extern "C" {
    #include <contrib/libs/openssl/include/crypto/poly1305.h>
    #include <contrib/libs/openssl/crypto/poly1305/poly1305_local.h>
}

#include <util/string/hex.h>

NPoly1305::TMac NPoly1305::Calc(const TKey& key, const void* data, size_t size) {
    TMac result;
    POLY1305 ctx;
    Poly1305_Init(&ctx, key.data());
    Poly1305_Update(&ctx, reinterpret_cast<const ui8*>(data), size);
    Poly1305_Final(&ctx, result.data());
    return result;
}

NPoly1305::TKey NPoly1305::ParseKey(TStringBuf encoded) {
    TKey result;
    TString decoded = HexDecode(encoded);
    Y_ENSURE_BT(decoded.size() == result.size(), "incorrect poly1305 key " << encoded << " size: " << decoded.size());
    MemMove(result.data(), reinterpret_cast<const ui8*>(decoded.data()), decoded.size());
    return result;
}

TExpected<NPoly1305::TKey> NPoly1305::TryParseKey(TStringBuf encoded) {
    return WrapUnexpected<yexception>(ParseKey, encoded);
}
