#pragma once

#include <rtline/util/types/expected.h>

#include <util/generic/strbuf.h>
#include <util/system/types.h>

#include <array>

namespace NPoly1305 {
    using TMac = std::array<ui8, 16>;
    using TKey = std::array<ui8, 32>;

    TMac Calc(const TKey& key, const void* data, size_t size);
    template <class T>
    TMac Calc(const TKey& key, const T& container) {
        return Calc(key, container.data(), container.size());
    }

    TKey ParseKey(TStringBuf encoded);
    TExpected<TKey> TryParseKey(TStringBuf encoded);
}
